#!/bin/sh

DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_OK=0
DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ERROR=1

DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=${DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ERROR}
DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0


dply_page_sc_image_path_select() {
	debug_print "in function '${FUNCNAME[0]}'"
    
    # check if there is any available SandboxController image first
    utility_get_esxi_all_vmx_files \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}" \
        "${conf_sc_prefix}"
    if [ -z "${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}" ]; then
        DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE="${DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR}"
        DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
        DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG="${ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SC}"
        return
    fi

    tp_esxi_image_select \
        "${DPLY_PAGE_SC_IMAGE_PATH_SELECT_TITLE}" \
        "${DPLY_PAGE_SC_IMAGE_PATH_SELECT_TEXT}" \
        "${DPLY_PAGE_SC_IMAGE_PATH_SELECT_LABEL_OK}" \
        "${DPLY_PAGE_SC_IMAGE_PATH_SELECT_LABEL_CANCEL}" \
        "${RT_ESXI_IP}" \
        "${RT_ESXI_USERNAME}" \
        "${RT_ESXI_PASSWORD}" \
        "${conf_sc_prefix}"
        
    debug_print "TP_ESXI_IMAGE_SELECT_RESULT_CODE: ${TP_ESXI_IMAGE_SELECT_RESULT_CODE}"
    case "${TP_ESXI_IMAGE_SELECT_RESULT_CODE}" in
    
        "${TP_ESXI_IMAGE_SELECT_RESULT_ERROR}" )
			debug_print "${TP_ESXI_IMAGE_SELECT_RESULT_MSG}"
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ERROR
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
			if [ "${TP_ESXI_IMAGE_SELECT_RESULT_MSG}" == "${TP_ESXI_IMAGE_SELECT_ERROR_DATASTORE_IS_NOT_FOUND}" ]; then
				DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_DATASTORE
			else
				DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SC
			fi
            return
            ;;
        
        "${TP_ESXI_IMAGE_SELECT_RESULT_CANCEL}" )
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_OK
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_RESULT_CTRLC}" )
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_OK
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;

        "${TP_ESXI_IMAGE_SELECT_RESULT_OK}" )
            ;;
            
        * )
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ERROR
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG="${DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_UNKNOWN}"
            return
            ;;
    esac

    utility_save_sc_image_path_conf \
        "${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH}" \
        "${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ERROR
        DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG="${DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_SAVE_CONFIGURATION}"
        return
    fi
    
    # apply successfully
    RT_SC_IMAGE_PATH="${TP_ESXI_IMAGE_SELECT_RESULT_SELECT}"
    RT_SC_IMAGE_PATH_ESXI="${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH}"
    RT_SC_IMAGE_PATH_VIX="${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH_VIX}"
    debug_print "RT_SC_IMAGE_PATH: ${RT_SC_IMAGE_PATH}"
    debug_print "RT_SC_IMAGE_PATH_ESXI: ${RT_SC_IMAGE_PATH_ESXI}"
    debug_print "RT_SC_IMAGE_PATH_VIX: ${RT_SC_IMAGE_PATH_VIX}"
    
    # utility_generate_ssh_key
    # if [ "${?}" -ne 0 ]; then
        # DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ERROR
        # DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        # DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG="${DPLY_PAGE_SC_IMAGE_PATH_SELECT_ERROR_GENERATE_SSH_KEY}"
        # return
    # fi
    
    DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK
    DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=1
    DPLY_PAGE_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
}
